<?php $__env->startSection('title', __('report.stock_expiry_report')); ?>

<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1><?php echo e(__('report.stock_expiry_report')); ?></h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            <?php $__env->startComponent('components.filters', ['title' => __('report.filters')]); ?>
              <?php echo Form::open(['url' => action('ReportController@getStockExpiryReport'), 'method' => 'get', 'id' => 'stock_report_filter_form' ]); ?>

                <div class="col-md-3">
                    <div class="form-group">
                        <?php echo Form::label('location_id',  __('purchase.business_location') . ':'); ?>

                        <?php echo Form::select('location_id', $business_locations, null, ['class' => 'form-control select2', 'style' => 'width:100%']);; ?>

                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <?php echo Form::label('category_id','Category:'); ?>

                        <?php echo Form::select('category', $categories, null, ['placeholder' => 'All', 'class' => 'form-control select2', 'style' => 'width:100%', 'id' => 'category_id']);; ?>

                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <?php echo Form::label('sub_category_id','Sub Category:'); ?>

                        <?php echo Form::select('sub_category', array(), null, ['placeholder' => 'All', 'class' => 'form-control select2', 'style' => 'width:100%', 'id' => 'sub_category_id']);; ?>

                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <?php echo Form::label('brand','Brand:'); ?>

                        <?php echo Form::select('brand', $brands, null, ['placeholder' => 'All', 'class' => 'form-control select2', 'style' => 'width:100%']);; ?>

                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <?php echo Form::label('unit','Unit:'); ?>

                        <?php echo Form::select('unit', $units, null, ['placeholder' => 'All', 'class' => 'form-control select2', 'style' => 'width:100%']);; ?>

                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <?php echo Form::label('view_stock_filter', __('report.view_stocks') . ':'); ?>

                        <?php echo Form::select('view_stock_filter', $view_stock_filter, null, ['placeholder' => __('messages.all'), 'class' => 'form-control select2', 'style' => 'width:100%']);; ?>

                    </div>
                </div>
                <?php echo Form::close(); ?>

            <?php echo $__env->renderComponent(); ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <?php $__env->startComponent('components.widget', ['class' => 'box-primary']); ?>
            <div class="table-responsive">
                <table class="table table-bordered table-striped" id="stock_expiry_report_table">
                    <thead>
                        <tr>
                            <th><?php echo e(app('translator')->getFromJson('business.product')); ?></th>
                            <th>SKU</th>
                            <!-- <th><?php echo e(app('translator')->getFromJson('purchase.ref_no')); ?></th> -->
                            <th><?php echo e(app('translator')->getFromJson('business.location')); ?></th>
                            <th><?php echo e(app('translator')->getFromJson('report.stock_left')); ?></th>
                            <th><?php echo e(app('translator')->getFromJson('lang_v1.lot_number')); ?></th>
                            <th><?php echo e(app('translator')->getFromJson('product.exp_date')); ?></th>
                            <th><?php echo e(app('translator')->getFromJson('product.mfg_date')); ?></th>
                           <!--  <th><?php echo e(app('translator')->getFromJson('messages.edit')); ?></th> -->
                        </tr>
                    </thead>
                    <tfoot>
                        <tr class="bg-gray font-17 text-center footer-total">
                            <td colspan="3"><strong><?php echo e(app('translator')->getFromJson('sale.total')); ?>:</strong></td>
                            <td id="footer_total_stock_left"></td>
                            <td colspan="3"></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
            <?php echo $__env->renderComponent(); ?>
        </div>
    </div>
</section>
<!-- /.content -->

<div class="modal fade exp_update_modal" tabindex="-1" role="dialog">
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    <script src="<?php echo e(asset('js/report.js?v=' . $asset_v)); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>